(() => {
    "use strict";
    const modules_flsModules = {};
    function functions_FLS(message) {
        setTimeout((() => {
            if (window.FLS) console.log(message);
        }), 0);
    }
    function uniqArray(array) {
        return array.filter((function(item, index, self) {
            return self.indexOf(item) === index;
        }));
    }
    class ScrollWatcher {
        constructor(props) {
            let defaultConfig = {
                logging: true
            };
            this.config = Object.assign(defaultConfig, props);
            this.observer;
            !document.documentElement.classList.contains("watcher") ? this.scrollWatcherRun() : null;
        }
        scrollWatcherUpdate() {
            this.scrollWatcherRun();
        }
        scrollWatcherRun() {
            document.documentElement.classList.add("watcher");
            this.scrollWatcherConstructor(document.querySelectorAll("[data-watch]"));
        }
        scrollWatcherConstructor(items) {
            if (items.length) {
                this.scrollWatcherLogging(`Прокинувся, стежу за об'єктами (${items.length})...`);
                let uniqParams = uniqArray(Array.from(items).map((function(item) {
                    if (item.dataset.watch === "navigator" && !item.dataset.watchThreshold) {
                        let valueOfThreshold;
                        if (item.clientHeight > 2) {
                            valueOfThreshold = window.innerHeight / 2 / (item.clientHeight - 1);
                            if (valueOfThreshold > 1) valueOfThreshold = 1;
                        } else valueOfThreshold = 1;
                        item.setAttribute("data-watch-threshold", valueOfThreshold.toFixed(2));
                    }
                    return `${item.dataset.watchRoot ? item.dataset.watchRoot : null}|${item.dataset.watchMargin ? item.dataset.watchMargin : "0px"}|${item.dataset.watchThreshold ? item.dataset.watchThreshold : 0}`;
                })));
                uniqParams.forEach((uniqParam => {
                    let uniqParamArray = uniqParam.split("|");
                    let paramsWatch = {
                        root: uniqParamArray[0],
                        margin: uniqParamArray[1],
                        threshold: uniqParamArray[2]
                    };
                    let groupItems = Array.from(items).filter((function(item) {
                        let watchRoot = item.dataset.watchRoot ? item.dataset.watchRoot : null;
                        let watchMargin = item.dataset.watchMargin ? item.dataset.watchMargin : "0px";
                        let watchThreshold = item.dataset.watchThreshold ? item.dataset.watchThreshold : 0;
                        if (String(watchRoot) === paramsWatch.root && String(watchMargin) === paramsWatch.margin && String(watchThreshold) === paramsWatch.threshold) return item;
                    }));
                    let configWatcher = this.getScrollWatcherConfig(paramsWatch);
                    this.scrollWatcherInit(groupItems, configWatcher);
                }));
            } else this.scrollWatcherLogging("Сплю, немає об'єктів для стеження. ZzzZZzz");
        }
        getScrollWatcherConfig(paramsWatch) {
            let configWatcher = {};
            if (document.querySelector(paramsWatch.root)) configWatcher.root = document.querySelector(paramsWatch.root); else if (paramsWatch.root !== "null") this.scrollWatcherLogging(`Эмм... батьківського об'єкта ${paramsWatch.root} немає на сторінці`);
            configWatcher.rootMargin = paramsWatch.margin;
            if (paramsWatch.margin.indexOf("px") < 0 && paramsWatch.margin.indexOf("%") < 0) {
                this.scrollWatcherLogging(`йой, налаштування data-watch-margin потрібно задавати в PX або %`);
                return;
            }
            if (paramsWatch.threshold === "prx") {
                paramsWatch.threshold = [];
                for (let i = 0; i <= 1; i += .005) paramsWatch.threshold.push(i);
            } else paramsWatch.threshold = paramsWatch.threshold.split(",");
            configWatcher.threshold = paramsWatch.threshold;
            return configWatcher;
        }
        scrollWatcherCreate(configWatcher) {
            console.log(configWatcher);
            this.observer = new IntersectionObserver(((entries, observer) => {
                entries.forEach((entry => {
                    this.scrollWatcherCallback(entry, observer);
                }));
            }), configWatcher);
        }
        scrollWatcherInit(items, configWatcher) {
            this.scrollWatcherCreate(configWatcher);
            items.forEach((item => this.observer.observe(item)));
        }
        scrollWatcherIntersecting(entry, targetElement) {
            if (entry.isIntersecting) {
                !targetElement.classList.contains("_watcher-view") ? targetElement.classList.add("_watcher-view") : null;
                this.scrollWatcherLogging(`Я бачу ${targetElement.classList}, додав клас _watcher-view`);
            } else {
                targetElement.classList.contains("_watcher-view") ? targetElement.classList.remove("_watcher-view") : null;
                this.scrollWatcherLogging(`Я не бачу ${targetElement.classList}, прибрав клас _watcher-view`);
            }
        }
        scrollWatcherOff(targetElement, observer) {
            observer.unobserve(targetElement);
            this.scrollWatcherLogging(`Я перестав стежити за ${targetElement.classList}`);
        }
        scrollWatcherLogging(message) {
            this.config.logging ? functions_FLS(`[Спостерігач]: ${message}`) : null;
        }
        scrollWatcherCallback(entry, observer) {
            const targetElement = entry.target;
            this.scrollWatcherIntersecting(entry, targetElement);
            targetElement.hasAttribute("data-watch-once") && entry.isIntersecting ? this.scrollWatcherOff(targetElement, observer) : null;
            document.dispatchEvent(new CustomEvent("watcherCallback", {
                detail: {
                    entry
                }
            }));
        }
    }
    modules_flsModules.watcher = new ScrollWatcher({});
    class Parallax {
        constructor(elements) {
            if (elements.length) this.elements = Array.from(elements).map((el => new Parallax.Each(el, this.options)));
        }
        destroyEvents() {
            this.elements.forEach((el => {
                el.destroyEvents();
            }));
        }
        setEvents() {
            this.elements.forEach((el => {
                el.setEvents();
            }));
        }
    }
    Parallax.Each = class {
        constructor(parent) {
            this.parent = parent;
            this.elements = this.parent.querySelectorAll("[data-prlx]");
            this.animation = this.animationFrame.bind(this);
            this.offset = 0;
            this.value = 0;
            this.smooth = parent.dataset.prlxSmooth ? Number(parent.dataset.prlxSmooth) : 15;
            this.setEvents();
        }
        setEvents() {
            this.animationID = window.requestAnimationFrame(this.animation);
        }
        destroyEvents() {
            window.cancelAnimationFrame(this.animationID);
        }
        animationFrame() {
            const topToWindow = this.parent.getBoundingClientRect().top;
            const heightParent = this.parent.offsetHeight;
            const heightWindow = window.innerHeight;
            const positionParent = {
                top: topToWindow - heightWindow,
                bottom: topToWindow + heightParent
            };
            const centerPoint = this.parent.dataset.prlxCenter ? this.parent.dataset.prlxCenter : "center";
            if (positionParent.top < 30 && positionParent.bottom > -30) switch (centerPoint) {
              case "top":
                this.offset = -1 * topToWindow;
                break;

              case "center":
                this.offset = heightWindow / 2 - (topToWindow + heightParent / 2);
                break;

              case "bottom":
                this.offset = heightWindow - (topToWindow + heightParent);
                break;
            }
            this.value += (this.offset - this.value) / this.smooth;
            this.animationID = window.requestAnimationFrame(this.animation);
            this.elements.forEach((el => {
                const parameters = {
                    axis: el.dataset.axis ? el.dataset.axis : "v",
                    direction: el.dataset.direction ? el.dataset.direction + "1" : "-1",
                    coefficient: el.dataset.coefficient ? Number(el.dataset.coefficient) : 5,
                    additionalProperties: el.dataset.properties ? el.dataset.properties : ""
                };
                this.parameters(el, parameters);
            }));
        }
        parameters(el, parameters) {
            if (parameters.axis == "v") el.style.transform = `translate3D(0, ${(parameters.direction * (this.value / parameters.coefficient)).toFixed(2)}px,0) ${parameters.additionalProperties}`; else if (parameters.axis == "h") el.style.transform = `translate3D(${(parameters.direction * (this.value / parameters.coefficient)).toFixed(2)}px,0,0) ${parameters.additionalProperties}`;
        }
    };
    if (document.querySelectorAll("[data-prlx-parent]")) modules_flsModules.parallax = new Parallax(document.querySelectorAll("[data-prlx-parent]"));
    let addWindowScrollEvent = false;
    setTimeout((() => {
        if (addWindowScrollEvent) {
            let windowScroll = new Event("windowScroll");
            window.addEventListener("scroll", (function(e) {
                document.dispatchEvent(windowScroll);
            }));
        }
    }), 0);
    document.addEventListener("DOMContentLoaded", (function() {
        const burgerBtn = document.getElementById("burgerBtn");
        const mainNav = document.getElementById("mainNav");
        const navLinks = document.querySelectorAll(".nav__link");
        if (burgerBtn && mainNav) {
            burgerBtn.addEventListener("click", (() => {
                mainNav.classList.toggle("active");
                burgerBtn.classList.toggle("active");
            }));
            navLinks.forEach((link => {
                link.addEventListener("click", (() => {
                    if (window.innerWidth <= 991.98) {
                        mainNav.classList.remove("active");
                        burgerBtn.classList.remove("active");
                    }
                }));
            }));
            document.addEventListener("click", (e => {
                if (!mainNav.contains(e.target) && !burgerBtn.contains(e.target)) {
                    mainNav.classList.remove("active");
                    burgerBtn.classList.remove("active");
                }
            }));
        }
        function setActiveNavLink() {
            let currentFile = window.location.pathname.split("/").pop() || "index";
            currentFile = currentFile.replace(/\.html$/, "") || "index";
            navLinks.forEach((link => {
                link.classList.remove("nav__link--active");
                let linkFile = link.getAttribute("href") || "";
                linkFile = linkFile.split("/").pop().replace(/\.html$/, "") || "index";
                if (linkFile === currentFile) link.classList.add("nav__link--active");
            }));
        }
        setActiveNavLink();
        const ecosystemTabs = document.querySelectorAll(".ecosystem__tab");
        const ecosystemPanels = document.querySelectorAll(".ecosystem__panel");
        if (ecosystemTabs.length > 0) ecosystemTabs.forEach((tab => {
            tab.addEventListener("click", (function() {
                const tabName = this.getAttribute("data-tab");
                ecosystemTabs.forEach((t => t.classList.remove("ecosystem__tab--active")));
                this.classList.add("ecosystem__tab--active");
                const currentActivePanel = document.querySelector(".ecosystem__panel--active");
                if (currentActivePanel) {
                    const currentPanelName = currentActivePanel.getAttribute("data-panel");
                    if (currentPanelName !== tabName) {
                        currentActivePanel.classList.remove("ecosystem__panel--active");
                        currentActivePanel.classList.add("ecosystem__panel--exit");
                        setTimeout((() => {
                            currentActivePanel.classList.remove("ecosystem__panel--exit");
                            ecosystemPanels.forEach((panel => {
                                const panelName = panel.getAttribute("data-panel");
                                if (panelName === tabName) panel.classList.add("ecosystem__panel--active");
                            }));
                        }), 100);
                    }
                } else ecosystemPanels.forEach((panel => {
                    const panelName = panel.getAttribute("data-panel");
                    if (panelName === tabName) panel.classList.add("ecosystem__panel--active");
                }));
            }));
        }));
        const newsletterForm = document.querySelector(".footer__newsletter-form");
        if (newsletterForm) {
            let successNotification = document.createElement("div");
            successNotification.className = "newsletter-success";
            successNotification.innerHTML = `\n            <svg width="20" height="20" viewBox="0 0 20 20" fill="none">\n                <circle cx="10" cy="10" r="8" stroke="#48a3ff" stroke-width="2"/>\n                <path d="M6 10L9 13L14 8" stroke="#48a3ff" stroke-width="2" stroke-linecap="round"/>\n            </svg>\n            <span>Successfully subscribed!</span>\n        `;
            successNotification.style.display = "none";
            newsletterForm.parentElement.style.position = "relative";
            newsletterForm.parentElement.appendChild(successNotification);
            newsletterForm.addEventListener("submit", (function(e) {
                e.preventDefault();
                const emailInput = this.querySelector('input[type="email"]');
                const submitButton = this.querySelector('button[type="submit"]');
                if (emailInput && emailInput.value.trim()) {
                    const originalButtonText = submitButton.innerHTML;
                    setTimeout((() => {
                        emailInput.value = "";
                        submitButton.innerHTML = originalButtonText;
                        submitButton.disabled = false;
                        successNotification.style.display = "flex";
                        successNotification.style.animation = "slideInUp 0.5s ease";
                        setTimeout((() => {
                            successNotification.style.animation = "fadeOut 0.5s ease";
                            setTimeout((() => {
                                successNotification.style.display = "none";
                            }), 400);
                        }), 3e3);
                    }), 500);
                }
            }));
        }
    }));
    document.addEventListener("DOMContentLoaded", (function() {
        const searchInput = document.getElementById("helpSearchInput");
        const categoryTabs = document.querySelectorAll(".help-categories__tab");
        const questions = document.querySelectorAll(".help-question");
        const noResults = document.getElementById("noResults");
        const contactForm = document.getElementById("contactForm");
        let currentCategory = "all";
        let searchTerm = "";
        function highlightNode(node, search) {
            if (!search) return;
            const escapedSearch = search.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
            function traverse(node) {
                if (node.nodeType === 3) {
                    const text = node.textContent;
                    const regex = new RegExp(escapedSearch, "gi");
                    if (regex.test(text)) {
                        const fragment = document.createDocumentFragment();
                        let lastIndex = 0;
                        const regex2 = new RegExp(escapedSearch, "gi");
                        let match;
                        while ((match = regex2.exec(text)) !== null) {
                            if (match.index > lastIndex) fragment.appendChild(document.createTextNode(text.slice(lastIndex, match.index)));
                            const mark = document.createElement("mark");
                            mark.className = "search-highlight";
                            mark.textContent = match[0];
                            fragment.appendChild(mark);
                            lastIndex = regex2.lastIndex;
                        }
                        if (lastIndex < text.length) fragment.appendChild(document.createTextNode(text.slice(lastIndex)));
                        node.parentNode.replaceChild(fragment, node);
                    }
                } else if (node.nodeType === 1 && node.tagName !== "SCRIPT" && node.tagName !== "STYLE" && !node.classList.contains("search-highlight")) {
                    const children = [ ...node.childNodes ];
                    children.forEach((child => traverse(child)));
                }
            }
            traverse(node);
        }
        function clearHighlights(element) {
            const marks = element.querySelectorAll("mark.search-highlight");
            marks.forEach((mark => {
                const textNode = document.createTextNode(mark.textContent);
                mark.parentNode.replaceChild(textNode, mark);
            }));
            element.normalize();
        }
        function filterQuestions() {
            let visibleCount = 0;
            questions.forEach((question => {
                const category = question.getAttribute("data-category");
                const titleElement = question.querySelector(".help-question__title");
                const contentElement = question.querySelector(".help-question__content");
                const title = titleElement.textContent.toLowerCase();
                const content = contentElement.textContent.toLowerCase();
                const matchesCategory = currentCategory === "all" || category === currentCategory;
                const matchesSearch = !searchTerm || title.includes(searchTerm) || content.includes(searchTerm);
                if (matchesCategory && matchesSearch) {
                    question.classList.remove("hidden");
                    visibleCount++;
                    clearHighlights(titleElement);
                    clearHighlights(contentElement);
                    if (searchTerm) {
                        highlightNode(titleElement, searchTerm);
                        highlightNode(contentElement, searchTerm);
                    }
                } else {
                    question.classList.add("hidden");
                    question.classList.remove("active");
                }
            }));
            if (visibleCount === 0) noResults.style.display = "block"; else noResults.style.display = "none";
        }
        if (searchInput) searchInput.addEventListener("input", (function(e) {
            searchTerm = e.target.value.toLowerCase().trim();
            filterQuestions();
        }));
        categoryTabs.forEach((tab => {
            tab.addEventListener("click", (function() {
                categoryTabs.forEach((t => t.classList.remove("help-categories__tab--active")));
                this.classList.add("help-categories__tab--active");
                currentCategory = this.getAttribute("data-category");
                filterQuestions();
            }));
        }));
        questions.forEach((question => {
            const header = question.querySelector(".help-question__header");
            header.addEventListener("click", (function() {
                const isActive = question.classList.contains("active");
                questions.forEach((q => q.classList.remove("active")));
                if (!isActive) question.classList.add("active");
            }));
        }));
        if (contactForm) {
            const formInputs = contactForm.querySelectorAll('.form-input, input[type="checkbox"]');
            function validateEmail(email) {
                const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return regex.test(email);
            }
            function showError(input, message) {
                const formGroup = input.closest(".form-group") || input.closest(".form-checkbox").parentElement;
                const errorElement = formGroup.querySelector(".form-error");
                input.classList.add("error");
                if (input.type === "checkbox") input.closest(".form-checkbox").classList.add("error");
                if (errorElement) errorElement.textContent = message;
            }
            function clearError(input) {
                const formGroup = input.closest(".form-group") || input.closest(".form-checkbox").parentElement;
                const errorElement = formGroup.querySelector(".form-error");
                input.classList.remove("error");
                if (input.type === "checkbox") input.closest(".form-checkbox").classList.remove("error");
                if (errorElement) errorElement.textContent = "";
            }
            function validateField(input) {
                clearError(input);
                if (input.hasAttribute("required")) if (input.type === "checkbox") {
                    if (!input.checked) {
                        showError(input, input.getAttribute("data-error"));
                        return false;
                    }
                } else if (!input.value.trim()) {
                    showError(input, input.getAttribute("data-error"));
                    return false;
                }
                if (input.type === "email" && input.value.trim()) if (!validateEmail(input.value.trim())) {
                    showError(input, input.getAttribute("data-error"));
                    return false;
                }
                if (input.hasAttribute("minlength")) {
                    const minLength = parseInt(input.getAttribute("minlength"));
                    if (input.value.trim().length < minLength) {
                        showError(input, input.getAttribute("data-error"));
                        return false;
                    }
                }
                return true;
            }
            formInputs.forEach((input => {
                input.addEventListener("blur", (function() {
                    validateField(this);
                }));
                input.addEventListener("input", (function() {
                    if (this.classList.contains("error")) clearError(this);
                }));
                if (input.type === "checkbox") input.addEventListener("change", (function() {
                    if (this.classList.contains("error")) clearError(this);
                }));
            }));
            contactForm.addEventListener("submit", (function(e) {
                e.preventDefault();
                let isValid = true;
                formInputs.forEach((input => {
                    if (!validateField(input)) isValid = false;
                }));
                if (!isValid) {
                    const firstError = contactForm.querySelector(".form-input.error, input.error");
                    if (firstError) {
                        firstError.focus();
                        firstError.scrollIntoView({
                            behavior: "smooth",
                            block: "center"
                        });
                    }
                    return;
                }
                const submitButton = contactForm.querySelector(".form-submit");
                const formSuccess = document.getElementById("formSuccess");
                submitButton.disabled = true;
                submitButton.textContent = "Sending...";
                setTimeout((() => {
                    contactForm.reset();
                    formSuccess.style.display = "flex";
                    submitButton.disabled = false;
                    submitButton.innerHTML = `\n                    Send Message\n                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none">\n                        <path d="M4 10H16M16 10L11 5M16 10L11 15" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n                    </svg>\n                `;
                    formInputs.forEach((input => {
                        clearError(input);
                    }));
                    setTimeout((() => {
                        formSuccess.style.display = "none";
                    }), 8e3);
                }), 1500);
            }));
        }
    }));
    document.addEventListener("DOMContentLoaded", (function() {
        const docsNav = Array.from(document.querySelectorAll(".docs-nav__link"));
        const docsSections = Array.from(document.querySelectorAll(".docs-section"));
        const copyButtons = Array.from(document.querySelectorAll(".docs-code__copy"));
        const accordionItems = Array.from(document.querySelectorAll(".docs-accordion__item"));
        let isAutoScrolling = false;
        function getHeaderHeight() {
            const header = document.querySelector(".header");
            return header && header.offsetHeight ? header.offsetHeight : 80;
        }
        function findSectionElementById(id) {
            if (!id) return null;
            let el = document.getElementById(id);
            if (el) return el;
            el = document.getElementById(`section-${id}`);
            return el;
        }
        function setActiveLinkById(id) {
            docsNav.forEach((link => {
                const ds = link.getAttribute("data-section");
                const href = link.getAttribute("href");
                const isActive = ds && ds === id || href && href.replace(/^#/, "") === id;
                link.classList.toggle("docs-nav__link--active", Boolean(isActive));
            }));
        }
        function smoothScrollToSectionId(id, updateHash = true) {
            const el = findSectionElementById(id);
            if (!el) return false;
            isAutoScrolling = true;
            const headerOffset = getHeaderHeight();
            const elementPosition = el.getBoundingClientRect().top + window.pageYOffset;
            const offsetPosition = Math.max(0, elementPosition - headerOffset - 20);
            window.scrollTo({
                top: offsetPosition,
                behavior: "smooth"
            });
            setActiveLinkById(id);
            if (updateHash) history.pushState(null, "", `#${id}`); else history.replaceState(null, "", `#${id}`);
            setTimeout((() => {
                isAutoScrolling = false;
            }), 900);
            return true;
        }
        function attemptScrollToHash(retries = 6, delay = 120) {
            const hash = window.location.hash.replace(/^#/, "");
            if (!hash) return;
            let attempt = 0;
            const tryScroll = () => {
                attempt++;
                const ok = smoothScrollToSectionId(hash, false);
                if (ok || attempt >= retries) return;
                setTimeout(tryScroll, delay);
            };
            tryScroll();
        }
        docsNav.forEach((link => {
            link.addEventListener("click", (function(e) {
                if (this.tagName.toLowerCase() === "a" && this.getAttribute("href")?.startsWith("#")) {
                    e.preventDefault();
                    const id = this.getAttribute("href").replace(/^#/, "");
                    smoothScrollToSectionId(id, true);
                    return;
                }
                const ds = this.getAttribute("data-section");
                if (ds) {
                    e.preventDefault();
                    smoothScrollToSectionId(ds, true);
                }
            }));
        }));
        const observerOptions = {
            root: null,
            rootMargin: "-100px 0px -66%",
            threshold: 0
        };
        const observer = new IntersectionObserver((entries => {
            if (isAutoScrolling) return;
            entries.forEach((entry => {
                if (entry.isIntersecting) {
                    const id = entry.target.getAttribute("id");
                    if (id) {
                        setActiveLinkById(id);
                        history.replaceState(null, "", `#${id}`);
                    }
                }
            }));
        }), observerOptions);
        docsSections.forEach((section => observer.observe(section)));
        if (window.location.hash) setTimeout((() => attemptScrollToHash(8, 120)), 50); else if (docsSections.length > 0) {
            const firstId = docsSections[0].getAttribute("id");
            if (firstId) setActiveLinkById(firstId);
        }
        window.addEventListener("hashchange", (() => {
            const newHash = window.location.hash.replace(/^#/, "");
            if (newHash) smoothScrollToSectionId(newHash, false);
        }));
        copyButtons.forEach((button => {
            button.addEventListener("click", (function() {
                const codeBlock = this.closest(".docs-code");
                const codeElement = codeBlock.querySelector(".docs-code__content code");
                if (!codeElement) return;
                const text = codeElement.textContent.trim();
                if (navigator.clipboard && window.isSecureContext) navigator.clipboard.writeText(text).then((() => showCopiedState(this))).catch((() => fallbackCopyText(text, this))); else fallbackCopyText(text, this);
            }));
        }));
        function fallbackCopyText(text, button) {
            const textarea = document.createElement("textarea");
            textarea.value = text;
            document.body.appendChild(textarea);
            textarea.select();
            try {
                document.execCommand("copy");
                showCopiedState(button);
            } catch (err) {
                console.error("Failed to copy text: ", err);
            }
            document.body.removeChild(textarea);
        }
        function showCopiedState(button) {
            const originalHTML = button.innerHTML;
            button.innerHTML = `\n\t\t\t<svg width="16" height="16" viewBox="0 0 16 16" fill="none">\n\t\t\t\t<path d="M3 8L6 11L13 4" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n\t\t\t</svg>\n\t\t`;
            button.style.color = "#48a3ff";
            setTimeout((() => {
                button.innerHTML = originalHTML;
                button.style.color = "";
            }), 2e3);
        }
        accordionItems.forEach((item => {
            const header = item.querySelector(".docs-accordion__header");
            header?.addEventListener("click", (function() {
                const isActive = item.classList.contains("active");
                accordionItems.forEach((i => i.classList.remove("active")));
                if (!isActive) item.classList.add("active");
            }));
        }));
        const mediaQuery = window.matchMedia("(max-width: 991.98px)");
        const docsSidebar = document.querySelector("#docsSidebar");
        function handleSidebarToggle() {
            if (mediaQuery.matches) {
                const sidebarToggle = document.createElement("button");
                sidebarToggle.className = "docs__sidebar-toggle";
                sidebarToggle.innerHTML = `\n\t\t\t\t<svg width="24" height="24" viewBox="0 0 24 24" fill="none">\n\t\t\t\t\t<path d="M3 6H21M3 12H21M3 18H21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>\n\t\t\t\t</svg>\n\t\t\t\t<span>Table of Contents</span>\n\t\t\t`;
                const docsInner = document.querySelector(".docs__inner");
                if (docsInner && !document.querySelector(".docs__sidebar-toggle")) {
                    docsInner.insertBefore(sidebarToggle, docsSidebar);
                    sidebarToggle.addEventListener("click", (function() {
                        docsSidebar.classList.toggle("active");
                        this.classList.toggle("active");
                    }));
                    document.addEventListener("click", (function(e) {
                        if (!docsSidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                            docsSidebar.classList.remove("active");
                            sidebarToggle.classList.remove("active");
                        }
                    }));
                    docsNav.forEach((link => {
                        link.addEventListener("click", (function() {
                            if (mediaQuery.matches) {
                                docsSidebar.classList.remove("active");
                                sidebarToggle.classList.remove("active");
                            }
                        }));
                    }));
                }
            }
        }
        handleSidebarToggle();
        mediaQuery.addEventListener("change", handleSidebarToggle);
        const searchInput = document.createElement("input");
        searchInput.type = "text";
        searchInput.className = "docs-search";
        searchInput.placeholder = "Search documentation...";
        const docsNavElement = document.querySelector(".docs-nav");
        if (docsNavElement) {
            docsNavElement.insertBefore(searchInput, docsNavElement.firstChild);
            searchInput.addEventListener("input", (function(e) {
                const searchTerm = e.target.value.toLowerCase().trim();
                const sections = document.querySelectorAll(".docs-nav__section");
                sections.forEach((section => {
                    const items = section.querySelectorAll(".docs-nav__item");
                    let hasVisibleItems = false;
                    items.forEach((item => {
                        const link = item.querySelector(".docs-nav__link");
                        const text = link.textContent.toLowerCase();
                        if (searchTerm === "" || text.includes(searchTerm)) {
                            item.style.display = "";
                            hasVisibleItems = true;
                        } else item.style.display = "none";
                    }));
                    if (searchTerm === "" || hasVisibleItems) section.style.display = ""; else section.style.display = "none";
                }));
            }));
        }
    }));
    document.addEventListener("DOMContentLoaded", (() => {
        const legalNavLinks = Array.from(document.querySelectorAll(".legal-nav__link"));
        const legalSections = Array.from(document.querySelectorAll(".legal-section"));
        if (!legalNavLinks.length || !legalSections.length) return;
        let isAutoScrolling = false;
        let ticking = false;
        function getOffset() {
            const header = 110;
            return header;
        }
        function smoothScrollTo(targetId) {
            const el = document.getElementById(targetId);
            if (!el) return;
            isAutoScrolling = true;
            const offset = getOffset();
            const top = el.getBoundingClientRect().top + window.pageYOffset - offset;
            window.scrollTo({
                top,
                behavior: "smooth"
            });
            setTimeout((() => {
                isAutoScrolling = false;
            }), 700);
        }
        function setActiveLink(targetId) {
            legalNavLinks.forEach((link => {
                const href = link.getAttribute("href") || "";
                const matches = href.replace(/^#/, "") === targetId;
                link.classList.toggle("active", matches);
                if (matches) link.setAttribute("aria-current", "true"); else link.removeAttribute("aria-current");
            }));
        }
        function detectCurrentSection() {
            const offset = getOffset() + 20;
            let currentId = null;
            let minDistance = 1 / 0;
            legalSections.forEach((section => {
                const rect = section.getBoundingClientRect();
                const distance = Math.abs(rect.top - offset);
                if (rect.bottom > offset) if (distance < minDistance) {
                    minDistance = distance;
                    currentId = section.id;
                }
            }));
            return currentId;
        }
        function onScroll() {
            if (ticking) return;
            ticking = true;
            requestAnimationFrame((() => {
                if (!isAutoScrolling) {
                    const id = detectCurrentSection();
                    if (id) {
                        setActiveLink(id);
                        history.replaceState(null, "", `#${id}`);
                    }
                }
                ticking = false;
            }));
        }
        legalNavLinks.forEach((link => {
            link.addEventListener("click", (e => {
                const href = link.getAttribute("href");
                if (!href || !href.startsWith("#")) return;
                e.preventDefault();
                const id = href.replace(/^#/, "");
                setActiveLink(id);
                smoothScrollTo(id);
                history.pushState(null, "", `#${id}`);
            }));
        }));
        if (window.location.hash) {
            const id = window.location.hash.replace(/^#/, "");
            setTimeout((() => {
                smoothScrollTo(id);
                setActiveLink(id);
            }), 120);
        } else {
            const initialId = detectCurrentSection() || legalSections[0] && legalSections[0].id;
            if (initialId) setActiveLink(initialId);
        }
        window.addEventListener("scroll", onScroll, {
            passive: true
        });
        window.addEventListener("resize", onScroll);
        window.addEventListener("hashchange", (() => {
            const id = window.location.hash.replace(/^#/, "");
            if (id) {
                setActiveLink(id);
                smoothScrollTo(id);
            }
        }));
    }));
    //! year in footer
        document.addEventListener("DOMContentLoaded", (function() {
        document.getElementById("year").textContent = (new Date).getFullYear();
    }));
    window["FLS"] = false;
})();